/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.internal.text;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.ruby.RubyEditorPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.ITokenScanner;

public class LineContinuationDamagerRepairer
extends ThemeingDamagerRepairer {
    public LineContinuationDamagerRepairer(ITokenScanner scanner) {
        super(scanner);
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        IRegion region = super.getDamageRegion(partition, e, documentPartitioningChanged);
        if (!documentPartitioningChanged) {
            try {
                int line = this.fDocument.getLineOfOffset(e.getOffset());
                if (line >= 1) {
                    String previousLine;
                    IRegion info = this.fDocument.getLineInformation(line - 1);
                    int start = Math.max(partition.getOffset(), info.getOffset());
                    int end = info.getOffset() + info.getLength();
                    int length = end - start;
                    if (length > 0 && (previousLine = this.fDocument.get(start, length)).endsWith("\\")) {
                        return new Region(start, region.getLength() + (length + 1));
                    }
                }
            }
            catch (BadLocationException e1) {
                IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (String)("Unable to check previous line for '\\' continuation, offset: " + e.getOffset()), (Throwable)e1);
            }
        }
        return region;
    }
}

